# Wiki Creation Process

How this wiki was created, for future iterations.

## Source Materials

1. **Transcript:** `jessie, pete, nameless one, 2026-02-20 - meeting_saved_closed_caption.txt` — Zoom closed captions, 9,073 lines, ~228 KB
2. **Chat:** `meeting_saved_new_chat.txt` — Zoom chat log with shared links, research notes, and context
3. **Instructions:** `Instructions for AI Assistant - Two-Person Call.md` — adapted from group call wiki process

## Tool

This wiki was built by [[Claude Code]] (Anthropic's CLI for Claude), working from the transcript and chat artifacts.

## Methodology

### Adaptation from Two-Person Template

The instructions were designed for a two-person call. This was a three-person call, requiring:
- Three participant pages instead of two
- Attention to the staggered entry (Pete and Jessie started; The Nameless One joined ~45 minutes in)
- Tracking three distinct voices and perspectives rather than two
- The core approach (dialogue over extraction, honest depth classification, preserve voice) carried over well

### Phases

1. **Analysis:** Read all source materials completely before creating any pages. Mapped conversation flow, classified depth of topics, identified all references.
2. **Wiki Creation:** Built infrastructure pages first, then participant pages, then thread pages (deep before medium), then reference pages.
3. **Orphan Resolution:** Used `_bin/find-orphan-links.py` to find all wiki links without corresponding files. Created pages for all orphans.
4. **Enrichment:** Re-read transcript sections to add quotes, connections, and dialogue texture to existing pages.
5. **Navigation:** Built indexes and cross-linking.

### Naming Conventions

- **The Nameless One:** Appears as "~" in transcript/chat, "Brother" in conversation. Wiki uses "The Nameless One" as the page name.
- **Claude/Cloud:** Transcription software rendered "Claude" as "Cloud" throughout. Wiki uses the correct "Claude."
- **Jesse/Jessie:** Transcript shows "Jesse," chat shows "Jessie Upp." Wiki uses "Jessie" as this appears in her own typed chat messages.

## Session 2: Enrichment and Synthesis

A follow-up session with Pete and Claude Code added external source material and new synthesis writing:

### External Documents Integrated
- **[[Inter-Face Manifesto]]** — Pete's standalone IFP vision document (written before the call), copied into the wiki and cross-linked to 9 existing pages
- **[Architectural and social aspects of mutual credit networks](https://peterkaminski.wiki/architectural_and_social_aspects_of_mutual_credit_networks)** — technical background on the Classic Ripple / mutual credit lineage behind A Thousand Small Mints, linked from relevant pages

### New Synthesis Pages
Three pages that articulate the larger pattern across the wiki:
1. **[[The Aquifer]]** — v1, a told parable with analytical coda
2. **[[The Aquifer, v2]]** — rewritten as a first-person narrative (narrator's cistern runs dry; they encounter the builder, the gardener, and the listener)
3. **[[The Nameless Can Never Be Named]]** — journalistic overview in modern indie longform style

### Key Editorial Decision
Pete corrected an early framing: the three participants aren't *discovering* convergence — they've known they're building the same thing. So do others in their network. The call was about groping toward how to do it together, pulled by something in the zeitgeist. All synthesis pages were revised to reflect this.

## Page Count

~50 pages total — appropriate for a three-person call that ran about 3 hours, enriched with external documents and synthesis writing.

## Prompts and Lessons

### What Worked Well
- The depth classification (deep/medium/brief) prevented inflation of brief mentions
- The Conversation Flow page as primary navigation spine works well for this format
- Preserving direct quotes extensively makes the wiki feel alive rather than summarized

### What Could Be Improved
- Three-person dynamics are harder to capture than two-person dialogue — the template could use a "trialogue" variant
- Screen-share moments (DayBalancer demo, Karameo demo) are hard to represent in text — these were mostly described narratively
- The spiritual/philosophical register of some of The Nameless One's contributions is harder to summarize without losing texture

## Related

- [[Work Log]] — process journal
- [[Details About This Wiki]] — technical notes
- [[Claude Code]] — the tool used
